//////////////////////////////////////////////
// main.cpp
//
//////////////////////////////////////////////

/// Includes ---------------------------------

// nkLog
#include <NilkinsLog/Loggers/ConsoleLogger.h>

// nkGraphics
#include <NilkinsGraphics/Log/LogManager.h>
#include <NilkinsGraphics/RenderContexts/RenderContextDescriptor.h>
#include <NilkinsGraphics/RenderContexts/RenderContextManager.h>
#include <NilkinsGraphics/System.h>

// Standards
#include <memory>

/// Function ---------------------------------

int main ()
{
	// Prepare logging capabilities
	std::unique_ptr<nkLog::Logger> logger = std::make_unique<nkLog::ConsoleLogger>() ;
	nkGraphics::LogManager::getInstance()->setReceiver(logger.get()) ;

	// Initialize the component
	if (!nkGraphics::System::getInstance()->initialize())
		return -1 ;

	// RenderContexts are environment in which it is possible to render
	// They can render to a window, or be offscreen
	// Main point is that it is possible to setup some parameters like their compositor, size, and more
	// This call create a render context and its window and link both of them together
	nkGraphics::RenderContext* context = nkGraphics::RenderContextManager::getInstance()->createRenderContext(nkGraphics::RenderContextDescriptor(800, 600, false, true)) ;

	// Then rendering can use that context to know where to render and what setup to use
	nkGraphics::System::getInstance()->run(context) ;

	// Then kill the instance, which will automatically clean its method through the shutdown method
	nkGraphics::System::getInstance()->kill() ;

	return 0 ;
}